/*
 * Decompiled with CFR 0.152.
 */
package jade.domain;

import jade.core.AID;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.FIPAAgentManagement.Property;
import jade.domain.FIPAAgentManagement.ServiceDescription;
import jade.domain.KBManagement.MemKB;
import jade.util.leap.ArrayList;
import jade.util.leap.Iterator;

public class DFMemKB
extends MemKB {
    boolean entriesToDelete = false;

    public DFMemKB(int maxResultLimit) {
        super(maxResultLimit);
        this.clean();
    }

    protected Object insert(Object name, Object fact) {
        DFAgentDescription desc = (DFAgentDescription)fact;
        if (desc.getLeaseTime() != null) {
            this.entriesToDelete = true;
        }
        return super.insert(name, fact);
    }

    protected void clean() {
        if (this.entriesToDelete) {
            ArrayList toBeRemoved = new ArrayList();
            Iterator iter = this.facts.values().iterator();
            while (iter.hasNext()) {
                DFAgentDescription dfd = (DFAgentDescription)iter.next();
                if (!dfd.checkLeaseTimeExpired()) continue;
                toBeRemoved.add(dfd.getName());
            }
            iter = toBeRemoved.iterator();
            while (iter.hasNext()) {
                this.facts.remove((AID)iter.next());
            }
        }
    }

    public final boolean match(Object template, Object fact) {
        return DFMemKB.compare(template, fact);
    }

    public static final boolean compare(Object template, Object fact) {
        try {
            Iterator itFact;
            boolean found;
            AID id2;
            DFAgentDescription templateDesc = (DFAgentDescription)template;
            DFAgentDescription factDesc = (DFAgentDescription)fact;
            if (factDesc.checkLeaseTimeExpired()) {
                return false;
            }
            AID id1 = templateDesc.getName();
            if (!(id1 == null || (id2 = factDesc.getName()) != null && MemKB.matchAID(id1, id2))) {
                return false;
            }
            Iterator itTemplate = templateDesc.getAllProtocols();
            while (itTemplate.hasNext()) {
                String templateProto = (String)itTemplate.next();
                found = false;
                itFact = factDesc.getAllProtocols();
                while (!found && itFact.hasNext()) {
                    String factProto = (String)itFact.next();
                    found = templateProto.equalsIgnoreCase(factProto);
                }
                if (found) continue;
                return false;
            }
            itTemplate = templateDesc.getAllOntologies();
            while (itTemplate.hasNext()) {
                String templateOnto = (String)itTemplate.next();
                found = false;
                itFact = factDesc.getAllOntologies();
                while (!found && itFact.hasNext()) {
                    String factOnto = (String)itFact.next();
                    found = templateOnto.equalsIgnoreCase(factOnto);
                }
                if (found) continue;
                return false;
            }
            itTemplate = templateDesc.getAllLanguages();
            while (itTemplate.hasNext()) {
                String templateLang = (String)itTemplate.next();
                found = false;
                itFact = factDesc.getAllLanguages();
                while (!found && itFact.hasNext()) {
                    String factLang = (String)itFact.next();
                    found = templateLang.equalsIgnoreCase(factLang);
                }
                if (found) continue;
                return false;
            }
            itTemplate = templateDesc.getAllServices();
            while (itTemplate.hasNext()) {
                ServiceDescription templateSvc = (ServiceDescription)itTemplate.next();
                found = false;
                itFact = factDesc.getAllServices();
                while (!found && itFact.hasNext()) {
                    ServiceDescription factSvc = (ServiceDescription)itFact.next();
                    found = DFMemKB.compareServiceDesc(templateSvc, factSvc);
                }
                if (found) continue;
                return false;
            }
            return true;
        }
        catch (ClassCastException cce) {
            return false;
        }
    }

    public static final boolean compareServiceDesc(ServiceDescription template, ServiceDescription fact) {
        Iterator itFact;
        boolean found;
        String o2;
        String t2;
        String n2;
        String n1 = template.getName();
        if (!(n1 == null || (n2 = fact.getName()) != null && n1.equalsIgnoreCase(n2))) {
            return false;
        }
        String t1 = template.getType();
        if (!(t1 == null || (t2 = fact.getType()) != null && t1.equalsIgnoreCase(t2))) {
            return false;
        }
        String o1 = template.getOwnership();
        if (!(o1 == null || (o2 = fact.getOwnership()) != null && o1.equalsIgnoreCase(o2))) {
            return false;
        }
        Iterator itTemplate = template.getAllOntologies();
        while (itTemplate.hasNext()) {
            String templateOnto = (String)itTemplate.next();
            found = false;
            itFact = fact.getAllOntologies();
            while (!found && itFact.hasNext()) {
                String factOnto = (String)itFact.next();
                found = templateOnto.equalsIgnoreCase(factOnto);
            }
            if (found) continue;
            return false;
        }
        itTemplate = template.getAllLanguages();
        while (itTemplate.hasNext()) {
            String templateLang = (String)itTemplate.next();
            found = false;
            itFact = fact.getAllLanguages();
            while (!found && itFact.hasNext()) {
                String factLang = (String)itFact.next();
                found = templateLang.equalsIgnoreCase(factLang);
            }
            if (found) continue;
            return false;
        }
        itTemplate = template.getAllProtocols();
        while (itTemplate.hasNext()) {
            String templateProto = (String)itTemplate.next();
            found = false;
            itFact = fact.getAllProtocols();
            while (!found && itFact.hasNext()) {
                String factProto = (String)itFact.next();
                found = templateProto.equalsIgnoreCase(factProto);
            }
            if (found) continue;
            return false;
        }
        itTemplate = template.getAllProperties();
        while (itTemplate.hasNext()) {
            Property templateProp = (Property)itTemplate.next();
            found = false;
            itFact = fact.getAllProperties();
            while (!found && itFact.hasNext()) {
                Property factProp = (Property)itFact.next();
                if (!templateProp.getName().equals(factProp.getName())) continue;
                Object templateValue = templateProp.getValue();
                found = templateValue == null ? true : (templateValue instanceof String ? ((String)templateValue).equalsIgnoreCase(factProp.getValue().toString()) : templateValue.equals(factProp.getValue()));
            }
            if (found) continue;
            return false;
        }
        return true;
    }
}

